(function ($, Drupal, drupalSettings) {
    "use strict";

    function responsiveChartBuilder(svg) {
        // get container + svg aspect ratio
        var container = d3.select(svg.node().parentNode),
            width = parseInt(svg.style("width")),
            height = parseInt(svg.style("height")),
            aspect = width / height;

        // add viewBox and preserveAspectRatio properties,
        // and call resize so that svg resizes on inital page load
        svg.attr("viewBox", "0 0 " + width + " " + height)
            .attr("preserveAspectRatio", "xMinYMid")
            .call(resize);

        // to register multiple listeners for same event type,
        // you need to add namespace, i.e., 'click.foo'
        // necessary if you call invoke this function for multiple svgs
        // api docs: https://github.com/mbostock/d3/wiki/Selections#on
        d3.select(window).on("resize." + container.attr("id"), resize);

        // get width of container and resize svg to fit it
        function resize() {
            var targetWidth = parseInt(container.style("width"));
            svg.attr("width", targetWidth);
            svg.attr("height", Math.round(targetWidth / aspect));
        }
    }

    function verticalChartHandler() {
        // Test si un container d3 est present dans le dom
        const chartHolder = $('.d3-chart-container');
        if (chartHolder.length === 0) return false;
        chartHolder.html('');

        // Test D3
        if (typeof d3 === "undefined") {
            console.error('Erreur lors de la création du graphique\n', 'Vous avez besoin de la lib D3js');
            return false;
        }

        const margin = {top: 25, right: 25, bottom: 60, left: 70};
        const width = 1100 - margin.left - margin.right;
        const height = 300 - margin.top - margin.bottom;

        // Config locale
        const fr_FR = {
            "decimal": ",",
            "thousands": "\u00a0",
            "grouping": [3],
            "currency": ["", "\u00a0€"],
            "percent": "\u202f%"
        };
        d3.formatDefaultLocale(fr_FR);

        let dataView = chartHolder.closest('.d3-chart-wrapper').find('.d3-chart-data');
        dataView = dataView.find('.view > .view-content');

        const dataViewRow = dataView.find('.views-row');
        let data = [];

        // Recupert les données dans la vue
        dataViewRow.each(function(idx, el){
            const $el = $(el);
            data.push({
                value: $el.find('.views-field-value > .field-content').text().trim(),
                date: $el.find('.views-field-date > .field-content').text().trim()
            })
        });

        // Si pas de donnée abandonner la création du graph
        if (!data.length) return false;

        // Cacher la vue contenant les données
        dataView.hide();

        const svg = d3.select(chartHolder[0])
            .append('svg')
            .attr('width', width + margin.left + margin.right)
            .attr('height', height + margin.top + margin.bottom)
            .call(responsiveChartBuilder)
            .append('g')
            .attr('transform', 'translate(' + margin.left + ', ' + margin.top + ')');

        const xScale = d3.scaleBand()
            .padding(0.2)
            .domain(data.map(function(d) {return d.date}))
            .range([0, width]);

        const yScale = d3.scaleLinear()
            .domain([0, d3.max(data, function (d) { return d.value; })])
            .range([height, 0]);

        svg.selectAll('.bar')
            .data(data)
            .enter()
            .append('rect')
            .attr('class', 'bar')
            .attr('x', function(d) { return xScale(d.date) })
            .attr('y', function(d) { return height})
            .attr('width', xScale.bandwidth())
            .transition()
            .duration(600)
            .ease(d3.easePolyOut)
            .attr('y', function(d) { return yScale(d.value)})
            .attr('height', function(d) {return height - yScale(d.value)})
            .each(function(d, i, a) {
                d3.select(a[i])
                    .attr('data-key', d.date);
            })

        svg.selectAll('.overlay')
            .data(data)
            .enter()
            .append('rect')
            .attr('class', 'overlay')
            .attr('x', function(d) { return xScale(d.date)})
            .attr('y', 0)
            .attr('width', xScale.bandwidth())
            .attr('height', height + 30)
            .attr('fill', 'transparent')
            .style('cursor', 'pointer')
            .on('mouseover', function(d) {
                d3.selectAll('[data-key="'+d.date+'"]')
                    .classed('active', true);
            })
            .on('mouseout', function(d) {
                d3.selectAll('[data-key="'+d.date+'"]')
                    .classed('active', false);
            })
        const yAxis = d3.axisLeft(yScale.nice())
            .tickFormat(d3.format('.0f'))
            .ticks(4);

        svg.append('g')
            .call(yAxis);

        const xAxis = d3.axisBottom(xScale)
            .ticks(4);

        svg.append('g')
            .attr("class", "axis axis-x")
            .attr("transform", 'translate(0,'+height+')')
            .call(xAxis);
    }


    // ------------------------------------------
    //  DOM READY CODE
    // ------------------------------------------
    $(function () {

        //Dropdown multiples sur page Documentation
        if ($('body:not(.path-documentation) .documentation').length){
            $('.caret-dropdown').on("click", function(e){
                console.log('Click on caret');
                $(this).parent('a').next('ul').toggle();
                $(this).parent('a').toggleClass('down').toggleClass('up');
                $(this).toggleClass('down').toggleClass('up');
                e.stopPropagation();
                e.preventDefault();
            });
        }
        if ($('.path-documentation, .page-node-type-documentation').length){

            $('.path-documentation .toggle-menu .open, .page-node-type-documentation .toggle-menu .open').click(function() {
              var leftMenu = $('.path-documentation .left-menu, .page-node-type-documentation .left-menu');
              $(this).hide();
              $('.path-documentation .toggle-menu .close, .page-node-type-documentation .toggle-menu .close').show();
              leftMenu.show();
              $([document.documentElement, document.body]).animate({
                scrollTop: leftMenu.offset().top
              }, 300);
            });

          $('.path-documentation .toggle-menu .close, .page-node-type-documentation .toggle-menu .close').click(function() {
            var OpenMenu = $('.path-documentation .toggle-menu .open, .page-node-type-documentation .toggle-menu .open');
            $(this).hide();
            OpenMenu.show();
            $('.path-documentation .left-menu, .page-node-type-documentation .left-menu').hide();
            $([document.documentElement, document.body]).animate({
              scrollTop: OpenMenu.offset().top
            }, 300);
          });

            $('.caret-dropdown').on("click", function(e){
                console.log('Click on caret');

                if($(window).width() <= 991) {
                  //$('.dropdown-submenu').removeClass('selected-submenu');

                  // On déplie le submenu
                  if($(this).hasClass('down')) {

                    $(this).parent().parent().css('color','red');
                    $(this).parent().parent().siblings('.selected-submenu').find('.caret-dropdown.up').each(function() {
                      $(this).parent('a').next('ul').toggle();
                      $(this).parent('a').toggleClass('down').toggleClass('up');
                      $(this).toggleClass('up').toggleClass('down');
                      $(this).closest('.dropdown-submenu').removeClass('selected-submenu');
                    });
                    $(this).closest('.dropdown-submenu').addClass('selected-submenu');
                    $([document.documentElement, document.body]).animate({
                      scrollTop: $(this).parents('.dropdown-submenu').offset().top
                    }, 300);
                  }
                  // On replie le submenu
                  else {
                    var submenu = $(this).parent().parent();
                    // On replie les submenu enfants
                    $(this).parent().siblings('.dropdown-menu').find('.caret-dropdown.up').each(function() {
                      $(this).parent('a').next('ul').toggle();
                      $(this).parent('a').toggleClass('down').toggleClass('up');
                      $(this).toggleClass('up').toggleClass('down');
                      $(this).closest('.dropdown-submenu').removeClass('selected-submenu');
                    });
                    $(this).parent().parent().parent().parent().addClass('selected-submenu');
                    $(this).closest('.dropdown-submenu').removeClass('selected-submenu');
                    $(this).closest('.dropdown-submenu').children('dropdown-menu').hide();
                    $(this).closest('.dropdown-submenu').children('a').removeClass('up');
                    $(this).closest('.dropdown-submenu').children('a').addClass('down');
                    $(this).closest('.dropdown-submenu').children('a').removeClass('up');
                    $(this).closest('.dropdown-submenu').children('a').addClass('down');
                    $([document.documentElement, document.body]).animate({
                      scrollTop: $(this).parents('.dropdown-submenu').parent().offset().top
                    }, 300);
                  }

                }

                $(this).parent('a').next('ul').toggle();
                $(this).parent('a').toggleClass('down').toggleClass('up');
                $(this).toggleClass('up').toggleClass('down');
                e.stopPropagation();
                e.preventDefault();
            });
        }

        if ($("body:not(.page-node-type-documentation) .paragraph--type--carrousel").length) {
            $("body:not(.page-node-type-documentation) .paragraph--type--carrousel>.field--name-field-contenu>.field--items").each(function () {
                $(this).slick({
                    dots: true,
                    arrows: true,
                    infinite: false,
                    speed: 300,
                    slidesToShow: 3,
                    slidesToScroll: 3,
                    responsive: [
                        {
                            breakpoint: 992,
                            settings: {
                                slidesToShow: 2,
                                slidesToScroll: 2,
                                infinite: true,
                                arrows: true,
                                dots: true
                            }
                        },
                        {
                            breakpoint: 768,
                            settings: {
                                slidesToShow: 1,
                                slidesToScroll: 1,
                                infinite: true,
                                arrows: false,
                                dots: true
                            }
                        }]
                });
            });
        }
        if ($('.view-news-front>.view-content').length) {
            $('.view-news-front>.view-content').slick({
                dots: true,
                arrows: true,
                infinite: false,
                speed: 300,
                slidesToShow: 2,
                slidesToScroll: 2,
                responsive: [
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            infinite: true,
                            arrows: false,
                            dots: true
                        }
                    }]
            });
        }
        if ($(".documentation .paragraph--type--carrousel").length) {
            $(".documentation .paragraph--type--carrousel>.field--name-field-contenu>.field--items").each(function () {
                $(this).slick({
                    dots: true,
                    arrows: true,
                    infinite: false,
                    speed: 300,
                    slidesToShow: 2,
                    slidesToScroll: 2,
                    responsive: [
                        {
                            breakpoint: 768,
                            settings: {
                                slidesToShow: 1,
                                slidesToScroll: 1,
                                infinite: true,
                                arrows: false,
                                dots: true
                            }
                        }]
                });
            });
        }
        //
        // if ($('.view-liste-geoservices .edit-valid-services').length) {
        //   $(document).ajaxComplete(function () {
        //     openModal();
        //   });
        //   openModal();
        // }
        //
        // function openModal() {
        //   $('.view-liste-geoservices .edit-valid-services').on('click', function (e) {
        //     $('.view-liste-geoservices .modal-services-web').show();
        //     $('body').css({overflow: 'hidden'}).append('<div class="modal-overlay"></div>');
        //     $('.modal-overlay').css({height: $(window).height() + 'px'});
        //     return false;
        //   });
        //
        //   $('.view-liste-geoservices [data-drupal-selector=edit-cancel]').on('click', function (e) {
        //     e.preventDefault();
        //     $('.view-liste-geoservices .modal-services-web').hide();
        //     $('.modal-overlay').remove();
        //     $('body').css({overflow: 'initial'});
        //     return false;
        //   });
        // }

        function testInputVal(inputVal, label) {
            label.toggleClass('filled', inputVal > 0)
        }

        /**
         * Formulaire de la page Contact et création droit
         *
         *   - Gestion de l'affichage des labels
         */
        $('#contact-message-contact-message-form .form-item input, ' +
            '#block-formulaire-creation-droit .form-item input, ' +
            '#contact-message-contact-message-form .form-item textarea, ' +
            '#block-formulaire-creation-droit textarea')
            .each(function () {
                var _this = $(this);
                var _label = _this.closest('.form-item').find('label');

                _this.on('keyup focusin focusout change', function (e) {
                    var _this = $(this);
                    var inputLength = (_this.is(':focus') || _this.attr('placeholder')) ? 1 : (_this.val()).length;

                    testInputVal(inputLength, _label);
                });

                _this.trigger('keyup');
            });

        // Stats avec d3js
        verticalChartHandler();

        $('.close-modal-ign').click(function(e) {
          $(this).closest('.ui-dialog-content').dialog('close');
          return false;
        });

        //Le menu de navigation connecté doit se fermer si un click sur la page
        $('body.user-logged-in').click(function(e) {
            $('.account-menu-wrapper').collapse('hide');
        });

        // Hide popover user/menu when displaying the other one
        if($(window).width() < 992) {
          $('.account-nav, .burger-main-nav').click(function() {
            var target = $(this).attr('data-target');
            if(target == '.account-menu-wrapper' && $('.header-menu.collapse.in').length > 0 && $('account-menu-wrapper.collapse.in').length == 0) {
              $('.burger-main-nav').click();
            }
            else if(target == '.header-menu' && $('account-menu-wrapper.collapse.in').length > 0 && $('.header-menu.collapse.in').length == 0) {
              $('.account-nav').click();
            }
          });
        }



    });



    // ajaxStop
    $(document).ajaxStop(function(){
      verticalChartHandler();
      $('.close-modal-ign').click(function(e) {
        $(this).closest('.ui-dialog-content').dialog('close');
        return false;
      });
    });

})(jQuery, Drupal, drupalSettings);
